/*
 * Decompiled with CFR 0.152.
 */
package de.stahl.kopiermaschine;

import de.stahl.kopiermaschine.KeySetupFailedException;
import de.stahl.kopiermaschine.RequestManager;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.Properties;

public class KeyManager {
    private PrivateKey ownPrivateKey;
    private PublicKey otherPublicKey;

    public KeyManager(byte[] ownPrivateKeyBytes, byte[] otherPublicKeyBytes, RequestManager requestManager) throws KeySetupFailedException {
        boolean saveToPropertiesFile = false;
        if (ownPrivateKeyBytes == null || otherPublicKeyBytes == null) {
            saveToPropertiesFile = true;
            otherPublicKeyBytes = this.retrieveOtherPublicKey(requestManager);
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
                keyPairGenerator.initialize(2048);
                KeyPair keyPair = keyPairGenerator.generateKeyPair();
                ownPrivateKeyBytes = keyPair.getPrivate().getEncoded();
                this.sendOwnPublicKey(requestManager, keyPair.getPublic().getEncoded());
            }
            catch (NoSuchAlgorithmException e) {
                throw new KeySetupFailedException("RSA algorithm cannot be used", e);
            }
        }
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            this.ownPrivateKey = keyFactory.generatePrivate(new PKCS8EncodedKeySpec(ownPrivateKeyBytes));
            this.otherPublicKey = keyFactory.generatePublic(new X509EncodedKeySpec(otherPublicKeyBytes));
        }
        catch (NoSuchAlgorithmException e) {
            throw new KeySetupFailedException("RSA algorithm cannot be used", e);
        }
        catch (InvalidKeySpecException e) {
            throw new KeySetupFailedException("Key cannot be created from bytes", e);
        }
        if (saveToPropertiesFile) {
            Properties properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream("kopiermaschine-config.txt");
                properties.load(fis);
                fis.close();
            }
            catch (IOException e) {
                throw new KeySetupFailedException("Error reading the config file");
            }
            properties.setProperty("OWN_PRIVATE_KEY", Base64.getEncoder().encodeToString(this.ownPrivateKey.getEncoded()));
            properties.setProperty("OTHER_PUBLIC_KEY", Base64.getEncoder().encodeToString(this.otherPublicKey.getEncoded()));
            try {
                FileOutputStream fos = new FileOutputStream("kopiermaschine-config.txt");
                properties.store(fos, "");
                fos.close();
            }
            catch (IOException e) {
                throw new KeySetupFailedException("Error writing the config file");
            }
        }
    }

    private byte[] retrieveOtherPublicKey(RequestManager requestManager) throws KeySetupFailedException {
        String encodedKey = requestManager.retrieveOtherPublicKey();
        if (encodedKey == null) {
            throw new KeySetupFailedException("Could not retrieve other public key");
        }
        return Base64.getDecoder().decode(encodedKey);
    }

    private void sendOwnPublicKey(RequestManager requestManager, byte[] keyBytes) throws KeySetupFailedException {
        String encodedKey = Base64.getEncoder().encodeToString(keyBytes);
        if (!requestManager.sendOwnPublicKey(encodedKey)) {
            throw new KeySetupFailedException("Could not send own public key");
        }
    }

    public PrivateKey getOwnPrivateKey() {
        return this.ownPrivateKey;
    }

    public PublicKey getOtherPublicKey() {
        return this.otherPublicKey;
    }
}

